/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.flowsched.scheduler;

import com.ishland.flowsched.scheduler.Cancellable;
import com.ishland.flowsched.scheduler.CancellationSignaller;
import com.ishland.flowsched.scheduler.ExceptionHandlingAction;
import com.ishland.flowsched.scheduler.ItemHolder;
import com.ishland.flowsched.scheduler.ItemStatus;
import com.ishland.flowsched.scheduler.ItemTicket;
import com.ishland.flowsched.scheduler.KeyStatusPair;
import com.ishland.flowsched.scheduler.ObjectFactory;
import com.ishland.flowsched.util.Assertions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;

public abstract class StatusAdvancingScheduler<K, V, Ctx, UserData> {
    public static final Runnable NO_OP = () -> {};
    private final StampedLock itemsLock = new StampedLock();
    private final Object2ReferenceOpenHashMap<K, ItemHolder<K, V, Ctx, UserData>> items = new Object2ReferenceOpenHashMap<K, ItemHolder<K, V, Ctx, UserData>>(){

        protected void rehash(int newN) {
            if (this.n < newN) {
                super.rehash(newN);
            }
        }
    };
    private final ObjectFactory objectFactory;

    protected StatusAdvancingScheduler() {
        this(new ObjectFactory.DefaultObjectFactory());
    }

    protected StatusAdvancingScheduler(ObjectFactory objectFactory) {
        this.objectFactory = Objects.requireNonNull(objectFactory);
    }

    protected abstract Executor getBackgroundExecutor();

    protected Scheduler getSchedulerBackedByBackgroundExecutor() {
        return Schedulers.from((Executor)this.getBackgroundExecutor());
    }

    protected abstract ItemStatus<K, V, Ctx> getUnloadedStatus();

    protected abstract Ctx makeContext(ItemHolder<K, V, Ctx, UserData> var1, ItemStatus<K, V, Ctx> var2, KeyStatusPair<K, V, Ctx>[] var3, boolean var4);

    protected ExceptionHandlingAction handleTransactionException(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus, boolean isUpgrade, Throwable throwable) {
        throwable.printStackTrace();
        return ExceptionHandlingAction.MARK_BROKEN;
    }

    protected void handleUnrecoverableException(Throwable throwable) {
    }

    protected void onItemCreation(ItemHolder<K, V, Ctx, UserData> holder) {
    }

    protected void onItemRemoval(ItemHolder<K, V, Ctx, UserData> holder) {
    }

    protected void onItemUpgrade(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> statusReached) {
    }

    protected void onItemDowngrade(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> statusReached) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tickHolder0(ItemHolder<K, V, Ctx, UserData> holder) {
        ItemStatus<K, V, Ctx> nextStatus;
        ItemStatus<K, V, Ctx> current;
        K key = holder.getKey();
        if (this.getHolder(key) != holder) {
            return;
        }
        if (holder.isBusy()) {
            this.tickHandleBusy0(holder);
            return;
        }
        ItemHolder<K, V, Ctx, UserData> itemHolder = holder;
        synchronized (itemHolder) {
            if (holder.isBusy()) {
                holder.executeCriticalSectionAndBusy(() -> this.tickHandleBusy0(holder));
                return;
            }
            current = holder.getStatus();
            nextStatus = this.getNextStatus(current, holder.getTargetStatus());
            Assertions.assertTrue(holder.getStatus() == current);
            holder.validateCompletedFutures(current);
            if (nextStatus == current) {
                holder.flushUnloadedStatus(current);
                holder.validateCompletedFutures(current);
                if (current.equals(this.getUnloadedStatus())) {
                    if (holder.isDependencyDirty()) {
                        holder.executeCriticalSectionAndBusy(() -> holder.cleanupDependencies(this));
                        holder.markDirty(this);
                        return;
                    }
                    if (holder.holdsDependency()) {
                        if (holder.isDependencyDirty()) {
                            holder.markDirty(this);
                            return;
                        }
                        System.err.println(String.format("BUG: %s still holds some dependencies when ready for unloading", holder.getKey()));
                    }
                    this.onItemRemoval(holder);
                    holder.release();
                    long lock = this.itemsLock.writeLock();
                    try {
                        this.items.remove(key);
                    }
                    finally {
                        this.itemsLock.unlockWrite(lock);
                    }
                    return;
                }
                holder.executeCriticalSectionAndBusy(() -> holder.cleanupDependencies(this));
                return;
            }
        }
        Assertions.assertTrue(holder.getStatus() == current);
        if (current.ordinal() < nextStatus.ordinal()) {
            if ((holder.getFlags() & 2) != 0) {
                return;
            }
            Assertions.assertTrue(holder.getStatus() == current);
            holder.busyRefCounter().incrementRefCount();
            try {
                this.advanceStatus0(holder, nextStatus, key);
            }
            finally {
                holder.busyRefCounter().decrementRefCount();
            }
        }
        holder.busyRefCounter().incrementRefCount();
        try {
            this.downgradeStatus0(holder, current, nextStatus, key);
        }
        finally {
            holder.busyRefCounter().decrementRefCount();
        }
    }

    private void tickHandleBusy0(ItemHolder<K, V, Ctx, UserData> holder) {
        ItemStatus<K, V, Ctx> projectedCurrent;
        ItemStatus<K, V, Ctx> upgradingStatusTo = holder.upgradingStatusTo();
        ItemStatus<K, V, Ctx> current = holder.getStatus();
        ItemStatus<K, V, Ctx> nextStatus = this.getNextStatus(current, holder.getTargetStatus());
        ItemStatus<K, V, Ctx> itemStatus = projectedCurrent = upgradingStatusTo != null ? upgradingStatusTo : current;
        if (projectedCurrent.ordinal() > nextStatus.ordinal()) {
            holder.tryCancelUpgradeAction();
        }
        holder.consolidateMarkDirty(this);
    }

    private void downgradeStatus0(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> current, ItemStatus<K, V, Ctx> nextStatus, K key) {
        KeyStatusPair[] dependencies = holder.getDependencies(current);
        Assertions.assertTrue(dependencies != null, "No dependencies for downgrade");
        Cancellable cancellable = new Cancellable();
        AtomicReference<Object> contextRef = new AtomicReference<Object>(null);
        AtomicBoolean hasDowngraded = new AtomicBoolean(false);
        Completable completable = Completable.defer(() -> {
            Assertions.assertTrue(holder.isBusy());
            Ctx ctx = this.makeContext(holder, current, dependencies, false);
            Assertions.assertTrue(ctx != null);
            contextRef.set(ctx);
            Completable stage = current.preDowngradeFromThis(ctx, cancellable);
            return stage;
        }).andThen((CompletableSource)Completable.defer(() -> {
            Assertions.assertTrue(holder.isBusy());
            boolean success = holder.setStatus(nextStatus, false);
            Assertions.assertTrue(success, "setStatus on downgrade failed");
            hasDowngraded.set(true);
            Object ctx = contextRef.get();
            Objects.requireNonNull(ctx);
            Completable stage = current.downgradeFromThis(ctx, cancellable);
            return stage.cache();
        })).doOnEvent(throwable -> {
            try {
                Assertions.assertTrue(holder.isBusy());
                Throwable actual = throwable;
                while (actual instanceof CompletionException) {
                    CompletionException ex = (CompletionException)actual;
                    actual = ex.getCause();
                }
                if (cancellable.isCancelled() && actual instanceof CancellationException) {
                    if (hasDowngraded.get()) {
                        holder.setStatus(current, true);
                    }
                    holder.consolidateMarkDirty(this);
                    return;
                }
                ExceptionHandlingAction action = this.tryHandleTransactionException(holder, nextStatus, false, (Throwable)throwable);
                switch (action) {
                    case PROCEED: {
                        this.releaseDependencies(holder, current);
                        break;
                    }
                    case MARK_BROKEN: {
                        holder.setFlag(2);
                        this.clearDependencies0(holder, current);
                    }
                }
                holder.consolidateMarkDirty(this);
                this.onItemDowngrade(holder, nextStatus);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        holder.subscribeOp(completable);
    }

    private void advanceStatus0(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus, K key) {
        KeyStatusPair[] dependencies = nextStatus.getDependencies(holder);
        CancellationSignaller dependencyCompletable = this.getDependencyFuture0(dependencies, holder, nextStatus);
        Cancellable cancellable = new Cancellable();
        CancellationSignaller signaller = new CancellationSignaller(unused -> {
            cancellable.cancel();
            dependencyCompletable.cancel();
        });
        AtomicReference<Object> contextRef = new AtomicReference<Object>(null);
        Completable completable = Completable.create(emitter -> dependencyCompletable.addListener(throwable -> {
            if (throwable != null) {
                emitter.onError(throwable);
            } else {
                emitter.onComplete();
            }
        })).andThen((CompletableSource)Completable.defer(() -> {
            Assertions.assertTrue(holder.isBusy());
            Ctx ctx = this.makeContext(holder, nextStatus, dependencies, false);
            Assertions.assertTrue(ctx != null);
            contextRef.set(ctx);
            Completable stage = nextStatus.upgradeToThis(ctx, cancellable);
            return stage.cache();
        })).onErrorResumeNext(throwable -> {
            try {
                Assertions.assertTrue(holder.isBusy());
                Throwable actual = throwable;
                while (actual instanceof CompletionException) {
                    CompletionException ex = (CompletionException)actual;
                    actual = ex.getCause();
                }
                if (cancellable.isCancelled() && actual instanceof CancellationException) {
                    if (holder.getDependencies(nextStatus) != null) {
                        this.releaseDependencies(holder, nextStatus);
                    }
                    try {
                        signaller.fireComplete(actual);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    holder.consolidateMarkDirty(this);
                    return Completable.error((Throwable)throwable);
                }
                Assertions.assertTrue(holder.getDependencies(nextStatus) != null);
                ExceptionHandlingAction action = this.tryHandleTransactionException(holder, nextStatus, true, (Throwable)throwable);
                switch (action) {
                    case PROCEED: {
                        return Completable.complete();
                    }
                    case MARK_BROKEN: {
                        holder.setFlag(2);
                        this.clearDependencies0(holder, nextStatus);
                        holder.consolidateMarkDirty(this);
                        return Completable.error((Throwable)throwable);
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)action));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (throwable != null) {
                    throwable.addSuppressed(t);
                    return Completable.error((Throwable)throwable);
                }
                return Completable.error((Throwable)t);
            }
        }).doOnEvent(throwable -> {
            try {
                if (throwable == null) {
                    holder.setStatus(nextStatus, false);
                    this.rerequestDependencies(holder, nextStatus);
                    holder.consolidateMarkDirty(this);
                    this.onItemUpgrade(holder, nextStatus);
                }
                try {
                    signaller.fireComplete(null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            catch (Throwable t) {
                try {
                    holder.setFlag(2);
                    this.clearDependencies0(holder, nextStatus);
                    holder.consolidateMarkDirty(this);
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                t.printStackTrace();
            }
        }).andThen((CompletableSource)Completable.defer(() -> {
            Object ctx = contextRef.get();
            Assertions.assertTrue(ctx != null);
            return nextStatus.postUpgradeToThis(ctx).cache();
        }).onErrorResumeNext(throwable -> {
            ExceptionHandlingAction action = this.tryHandleTransactionException(holder, nextStatus, true, (Throwable)throwable);
            switch (action) {
                case PROCEED: {
                    return Completable.complete();
                }
                case MARK_BROKEN: {
                    holder.setFlag(2);
                    holder.consolidateMarkDirty(this);
                    holder.executeCriticalSectionAndBusy(() -> {
                        holder.busyRefCounter().incrementRefCount();
                        try {
                            this.downgradeStatus0(holder, nextStatus, nextStatus.getPrev(), key);
                        }
                        finally {
                            holder.busyRefCounter().decrementRefCount();
                        }
                    });
                    return Completable.error((Throwable)throwable);
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)action));
        })).onErrorComplete().cache();
        holder.submitUpgradeAction(signaller, nextStatus);
        holder.subscribeOp(completable);
        completable.subscribe(() -> signaller.fireComplete(null), signaller::fireComplete);
        Assertions.assertTrue(holder.isBusy() || cancellable.isCancelled() || holder.getStatus() == nextStatus);
    }

    private void rerequestDependencies(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> status) {
        KeyStatusPair<K, V, Ctx>[] curDep = holder.getDependencies(status);
        KeyStatusPair<K, V, Ctx>[] newDep = status.getDependencies(holder);
        KeyStatusPair<K, V, Ctx>[] toAdd = status.getDependenciesToAdd(holder);
        KeyStatusPair<K, V, Ctx>[] toRemove = status.getDependenciesToRemove(holder);
        holder.setDependencies(status, null);
        holder.setDependencies(status, newDep);
        for (KeyStatusPair<K, V, Ctx> pair : toAdd) {
            holder.addDependencyTicket(this, pair.key(), pair.status(), NO_OP);
        }
        for (KeyStatusPair<K, V, Ctx> pair : toRemove) {
            holder.removeDependencyTicket(pair.key(), pair.status());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemHolder<K, V, Ctx, UserData> getHolder(K key) {
        long stamp = this.itemsLock.tryOptimisticRead();
        if (stamp != 0L) {
            try {
                ItemHolder holder = (ItemHolder)this.items.get(key);
                if (this.itemsLock.validate(stamp)) {
                    return holder;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        stamp = this.itemsLock.readLock();
        try {
            ItemHolder itemHolder = (ItemHolder)this.items.get(key);
            return itemHolder;
        }
        finally {
            this.itemsLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemHolder<K, V, Ctx, UserData> getOrCreateHolder(K key) {
        ItemHolder<K, V, Ctx, UserData> holder = this.getHolder(key);
        if (holder != null) {
            return holder;
        }
        long lock = this.itemsLock.writeLock();
        try {
            ItemHolder itemHolder = (ItemHolder)this.items.computeIfAbsent(key, this::createHolder);
            return itemHolder;
        }
        finally {
            this.itemsLock.unlockWrite(lock);
        }
    }

    public int itemCount() {
        VarHandle.acquireFence();
        return this.items.size();
    }

    protected void wakeUp() {
    }

    private CancellationSignaller getDependencyFuture0(KeyStatusPair<K, V, Ctx>[] dependencies, ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus) {
        AtomicInteger satisfied = new AtomicInteger(0);
        int size = dependencies.length;
        holder.setDependencies(nextStatus, dependencies);
        if (size == 0) {
            return CancellationSignaller.COMPLETED;
        }
        AtomicBoolean finished = new AtomicBoolean(false);
        CancellationSignaller signaller = new CancellationSignaller(signaller1 -> {
            if (satisfied.get() == 0) {
                // empty if block
            }
            if (finished.compareAndSet(false, true)) {
                this.releaseDependencies(holder, nextStatus);
                signaller1.fireComplete(new CancellationException());
            }
        });
        try {
            KeyStatusPair<K, V, Ctx> keyStatusPair = new KeyStatusPair<K, V, Ctx>(holder.getKey(), nextStatus);
            for (KeyStatusPair<K, V, Ctx> dependency : dependencies) {
                Assertions.assertTrue(!dependency.key().equals(holder.getKey()));
                holder.addDependencyTicket(this, dependency.key(), dependency.status(), () -> {
                    int incrementAndGet = satisfied.incrementAndGet();
                    Assertions.assertTrue(incrementAndGet <= size, "Satisfied more than expected");
                    if (incrementAndGet == size && finished.compareAndSet(false, true)) {
                        holder.getCriticalSectionExecutor().execute(() -> signaller.fireComplete(null));
                    }
                });
            }
        }
        catch (Throwable t) {
            signaller.fireComplete(t);
        }
        return signaller;
    }

    public ItemHolder<K, V, Ctx, UserData> addTicket(K key, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        return this.addTicket(key, key, targetStatus, callback);
    }

    public ItemHolder<K, V, Ctx, UserData> addTicket(K key, Object source, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        return this.addTicket(key, ItemTicket.TicketType.EXTERNAL, source, targetStatus, callback);
    }

    public ItemHolder<K, V, Ctx, UserData> addTicket(K key, ItemTicket.TicketType type, Object source, ItemStatus<K, V, Ctx> targetStatus, Runnable callback) {
        return this.addTicket0(key, new ItemTicket<K, V, Ctx>(type, source, targetStatus, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemHolder<K, V, Ctx, UserData> addTicket0(K key, ItemTicket<K, V, Ctx> ticket) {
        if (this.getUnloadedStatus().equals(ticket.getTargetStatus())) {
            throw new IllegalArgumentException("Cannot add ticket to unloaded status");
        }
        try {
            ItemHolder<K, V, Ctx, UserData> holder;
            while (true) {
                ItemHolder<K, V, Ctx, UserData> itemHolder = holder = this.getOrCreateHolder(key);
                synchronized (itemHolder) {
                    if (holder.isOpen()) break;
                }
            }
            {
                holder.busyRefCounter().incrementRefCount();
            }
            try {
                holder.addTicket(ticket);
                holder.consolidateMarkDirty(this);
                return holder;
            }
            finally {
                holder.busyRefCounter().decrementRefCount();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private ItemHolder<K, V, Ctx, UserData> createHolder(K k) {
        ItemHolder holder1 = new ItemHolder(this.getUnloadedStatus(), k, this.objectFactory, this.getBackgroundExecutor());
        this.onItemCreation(holder1);
        VarHandle.fullFence();
        return holder1;
    }

    public void removeTicket(K key, ItemStatus<K, V, Ctx> targetStatus) {
        this.removeTicket(key, ItemTicket.TicketType.EXTERNAL, key, targetStatus);
    }

    public void removeTicket(K key, ItemTicket.TicketType type, Object source, ItemStatus<K, V, Ctx> targetStatus) {
        ItemHolder<K, V, Ctx, UserData> holder = this.getHolder(key);
        if (holder == null) {
            throw new IllegalStateException("No such item");
        }
        holder.removeTicket(new ItemTicket<K, V, Ctx>(type, source, targetStatus, null));
        holder.tryMarkDirty(this);
    }

    private ItemStatus<K, V, Ctx> getNextStatus(ItemStatus<K, V, Ctx> current, ItemStatus<K, V, Ctx> target) {
        Assertions.assertTrue(target != null);
        int compare = Integer.compare(current.ordinal(), target.ordinal());
        if (compare < 0) {
            return current.getNext();
        }
        if (compare == 0) {
            return current;
        }
        return current.getPrev();
    }

    private ExceptionHandlingAction tryHandleTransactionException(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> nextStatus, boolean isUpgrade, Throwable throwable) {
        if (throwable == null) {
            return ExceptionHandlingAction.PROCEED;
        }
        try {
            return this.handleTransactionException(holder, nextStatus, isUpgrade, throwable);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return ExceptionHandlingAction.MARK_BROKEN;
        }
    }

    private void clearDependencies0(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> fromStatus) {
        for (int i = fromStatus.ordinal(); i > 0; --i) {
            ItemStatus<K, V, Ctx> status = this.getUnloadedStatus().getAllStatuses()[i];
            this.releaseDependencies(holder, status);
            holder.setDependencies(status, new KeyStatusPair[0]);
        }
    }

    private void releaseDependencies(ItemHolder<K, V, Ctx, UserData> holder, ItemStatus<K, V, Ctx> status) {
        KeyStatusPair<K, V, Ctx>[] dependencies;
        for (KeyStatusPair<K, V, Ctx> dependency : dependencies = holder.getDependencies(status)) {
            holder.removeDependencyTicket(dependency.key(), dependency.status());
        }
        holder.setDependencies(status, null);
    }
}

